## CvSanguoEventManager
## This file is part of Civilization IV Sanguo python mod.

from CvPythonExtensions import *

import CvScreensInterface
import CvUtil
import PyHelpers
import Popup as PyPopup

import sys

#### Sanguo Mod City Naming, start, added by nk 11.13.08
import CvSanguoCityName
import time
#### Sanguo Mod City Naming, end

import OOSLogger
import BugUtil

gc = CyGlobalContext()
localText = CyTranslator()
PyPlayer = PyHelpers.PyPlayer
PyInfo = PyHelpers.PyInfo


# globals
###################################################
class CvSanguoEventManager:
	def __init__(self,  eventManager):
		# private		
		self.eventManager = eventManager
		self.beginTime = 0
		self.currentTime = 0
		self.totalTime = 0
		self.lNorthernCivList = []
		self.lSouthernCivList = []
		self.lSouthWesternCivList = []
		#### Religion Buildings, start, Added by poyuzhe 11.13.08
		eventManager.addEventHandler("religionSpread", self.onReligionSpread)
		eventManager.addEventHandler("playerChangeStateReligion", self.onPlayerChangeStateReligion)
		#### Religion Buildings, end 
		
		#### City Naming, start, added by nk 11.13.08
		eventManager.insertEventHandler('cityBuilt', self.onCityBuilt, 0)
		#### City Naming, end

		#### Civilization Trait, start, added by poyuzhe 11.25.08
		eventManager.addEventHandler("BeginGameTurn", self.onBeginGameTurn)
		#### Civilization Trait, end

		#### Official Belief, start, by poyuzhe 12.01.08
		eventManager.addEventHandler("religionFounded", self.onReligionFounded)
		eventManager.addEventHandler("techAcquired", self.onTechAcquired)
		#### Official Belief, end

		#### Emperor, start, added by poyuzhe 12.03.08
		eventManager.addEventHandler("improvementBuilt", self.onImprovementBuilt)
		eventManager.addEventHandler("unitKilled", self.onUnitKilled)
		#### Emperor, end

		#### OOS, start, added by poyuzhe 02.27.09
		eventManager.addEventHandler("gameUpdate", self.onGameUpdate)
		#### OOS, end

		#### Hero, start, added by poyuzhe 06.28.09
		eventManager.addEventHandler("ModNetMessage", self.onModNetMessage)
		eventManager.addEventHandler("GameStart", self.onGameStart)
		#### Hero, end
		
#################### ON EVENTS ######################
	#### City Naming, start, added by nk 11.13.08
	def onCityBuilt(self, argsList):
		'City Built'
		city = argsList[0]
		
		plot = city.plot()
		iX = plot.getX()
		iY = plot.getY()

		for key in CvSanguoCityName.CityNameDict:
			for (x,y) in [(iX+i, iY+j) for i in range(-1,2) for j in range(-1,2)]:
				if (x,y) == key:
					szNewCityName = CyTranslator().getText(CvSanguoCityName.CityNameDict[key], ())                                
					if (city.getOwner() == gc.getGame().getActivePlayer()):
						city.setName(szNewCityName, False)
					else:   
						city.setName(szNewCityName, True)
					return

		if gc.getPlayer(city.getOwner()).getCivilizationType() in self.lNorthernCivList:
			city.setHasCityPerk(gc.getInfoTypeForString("CITYPERK_NORTHERN"), True)
		elif gc.getPlayer(city.getOwner()).getCivilizationType() in self.lSouthernCivList:
			city.setHasCityPerk(gc.getInfoTypeForString("CITYPERK_SOUTHERN"), True)
		elif gc.getPlayer(city.getOwner()).getCivilizationType() in self.lSouthWesternCivList:
			city.setHasCityPerk(gc.getInfoTypeForString("CITYPERK_SOUTHWESTERN"), True)
	#### City Naming, end
	
	#### Religion Buildings, start, added by poyuzhe 11.13.08; edited by nk 11.14.08
	def onReligionSpread(self, argsList):
		'Religion Has Spread to a City'
		iReligion, iOwner, pSpreadCity = argsList
		player = PyPlayer(iOwner)

		pPlayer = gc.getPlayer(pSpreadCity.getOwner())
		if iReligion == pPlayer.getStateReligion():  # iReligion is always >= 0
		
			iClassTemple = gc.getInfoTypeForString("BUILDINGCLASS_TEMPLE_CHAOS")
			iClassCathedral = gc.getInfoTypeForString("BUILDINGCLASS_CATHEDRAL_CHAOS")
			iClassMonastery = gc.getInfoTypeForString("BUILDINGCLASS_MONASTERY_CHAOS")
			iTemple = gc.getCivilizationInfo(pPlayer.getCivilizationType()).getCivilizationBuildings(iClassTemple)
			iCathedral = gc.getCivilizationInfo(pPlayer.getCivilizationType()).getCivilizationBuildings(iClassCathedral)
			iMonastery = gc.getCivilizationInfo(pPlayer.getCivilizationType()).getCivilizationBuildings(iClassMonastery)

			dictReligionIndex = {gc.getInfoTypeForString("RELIGION_REVIVAL") : 'JEWISH',
					     gc.getInfoTypeForString("RELIGION_UNIFICATION") : 'CHRISTIAN',
					     gc.getInfoTypeForString("RELIGION_DIVISION") : 'ISLAMIC',
					     gc.getInfoTypeForString("RELIGION_REBELLION") : 'HINDU',
					     gc.getInfoTypeForString("RELIGION_PURE_FORCE") : 'BUDDHIST',
					     gc.getInfoTypeForString("RELIGION_RELIGION") : 'CONFUCIAN',
					     gc.getInfoTypeForString("RELIGION_HERMIT") : 'TAOIST'}                        

			szReligion = dictReligionIndex[iReligion]  # iReligion should be belong to [0,6]

			iNewClassTemple = gc.getInfoTypeForString('_'.join(['BUILDINGCLASS', szReligion, 'TEMPLE']))
			iNewClassCathedral = gc.getInfoTypeForString('_'.join(['BUILDINGCLASS', szReligion, 'CATHEDRAL']))
			iNewClassMonastery = gc.getInfoTypeForString('_'.join(['BUILDINGCLASS', szReligion, 'MONASTERY']))
			iNewTemple = gc.getCivilizationInfo(pPlayer.getCivilizationType()).getCivilizationBuildings(iNewClassTemple)
			iNewCathedral = gc.getCivilizationInfo(pPlayer.getCivilizationType()).getCivilizationBuildings(iNewClassCathedral)
			iNewMonastery = gc.getCivilizationInfo(pPlayer.getCivilizationType()).getCivilizationBuildings(iNewClassMonastery)
			
			if pSpreadCity.getNumRealBuilding(iTemple) == 1:
				pSpreadCity.setNumRealBuilding(iTemple, 0)
				pSpreadCity.setNumRealBuilding(iNewTemple, 1)
			elif pSpreadCity.getBuildingProduction(iTemple) > 0:
				pSpreadCity.setBuildingProduction(iNewTemple, pSpreadCity.getBuildingProduction(iTemple))
				pSpreadCity.setBuildingProductionTime(iNewTemple, pSpreadCity.getBuildingProductionTime(iTemple))
				pSpreadCity.setBuildingProduction(iTemple, 0)

			if pSpreadCity.getNumRealBuilding(iCathedral) == 1:
				pSpreadCity.setNumRealBuilding(iCathedral, 0)
				pSpreadCity.setNumRealBuilding(iNewCathedral, 1)
			elif pSpreadCity.getBuildingProduction(iCathedral) > 0:
				pSpreadCity.setBuildingProduction(iNewCathedral, pSpreadCity.getBuildingProduction(iCathedral))
				pSpreadCity.setBuildingProductionTime(iNewCathedral, pSpreadCity.getBuildingProductionTime(iCathedral))
				pSpreadCity.setBuildingProduction(iCathedral, 0)

			if pSpreadCity.getNumRealBuilding(iMonastery) == 1:
				pSpreadCity.setNumRealBuilding(iMonastery, 0)
				pSpreadCity.setNumRealBuilding(iNewMonastery, 1)
			elif pSpreadCity.getBuildingProduction(iMonastery) > 0:
				pSpreadCity.setBuildingProduction(iNewMonastery, pSpreadCity.getBuildingProduction(iMonastery))
				pSpreadCity.setBuildingProductionTime(iNewMonastery, pSpreadCity.getBuildingProductionTime(iMonastery))
				pSpreadCity.setBuildingProduction(iMonastery, 0)
			
	def onPlayerChangeStateReligion(self, argsList):
		'Player changes his state religion'
		iPlayer, iNewReligion, iOldReligion = argsList

		pPlayer = gc.getPlayer(iPlayer)

		dictReligionIndex = {gc.getInfoTypeForString("RELIGION_REVIVAL") : 'JEWISH',
				     gc.getInfoTypeForString("RELIGION_UNIFICATION") : 'CHRISTIAN',
				     gc.getInfoTypeForString("RELIGION_DIVISION") : 'ISLAMIC',
				     gc.getInfoTypeForString("RELIGION_REBELLION") : 'HINDU',
				     gc.getInfoTypeForString("RELIGION_PURE_FORCE") : 'BUDDHIST',
				     gc.getInfoTypeForString("RELIGION_RELIGION") : 'CONFUCIAN',
				     gc.getInfoTypeForString("RELIGION_HERMIT") : 'TAOIST'}  

		iClassChaosTemple = gc.getInfoTypeForString("BUILDINGCLASS_TEMPLE_CHAOS")
		iClassChaosCathedral = gc.getInfoTypeForString("BUILDINGCLASS_CATHEDRAL_CHAOS")
		iClassChaosMonastery = gc.getInfoTypeForString("BUILDINGCLASS_MONASTERY_CHAOS")
		iChaosTemple = gc.getCivilizationInfo(pPlayer.getCivilizationType()).getCivilizationBuildings(iClassChaosTemple)
		iChaosCathedral = gc.getCivilizationInfo(pPlayer.getCivilizationType()).getCivilizationBuildings(iClassChaosCathedral)
		iChaosMonastery = gc.getCivilizationInfo(pPlayer.getCivilizationType()).getCivilizationBuildings(iClassChaosMonastery)
		
		if iNewReligion != -1:
			szNewReligion = dictReligionIndex[iNewReligion]
			iNewClassTemple = gc.getInfoTypeForString('_'.join(['BUILDINGCLASS', szNewReligion, 'TEMPLE']))
			iNewClassCathedral = gc.getInfoTypeForString('_'.join(['BUILDINGCLASS', szNewReligion, 'CATHEDRAL']))
			iNewClassMonastery = gc.getInfoTypeForString('_'.join(['BUILDINGCLASS', szNewReligion, 'MONASTERY']))
			iNewTemple = gc.getCivilizationInfo(pPlayer.getCivilizationType()).getCivilizationBuildings(iNewClassTemple)
			iNewCathedral = gc.getCivilizationInfo(pPlayer.getCivilizationType()).getCivilizationBuildings(iNewClassCathedral)
			iNewMonastery = gc.getCivilizationInfo(pPlayer.getCivilizationType()).getCivilizationBuildings(iNewClassMonastery)
		else:
			iNewTemple = iChaosTemple
			iNewCathedral = iChaosCathedral
			iNewMonastery = iChaosMonastery
		
		if iOldReligion != -1:
			szOldReligion = dictReligionIndex[iOldReligion]
			iOldClassTemple = gc.getInfoTypeForString('_'.join(['BUILDINGCLASS', szOldReligion, 'TEMPLE']))
			iOldClassCathedral = gc.getInfoTypeForString('_'.join(['BUILDINGCLASS', szOldReligion, 'CATHEDRAL']))
			iOldClassMonastery = gc.getInfoTypeForString('_'.join(['BUILDINGCLASS', szOldReligion, 'MONASTERY']))
			iOldTemple = gc.getCivilizationInfo(pPlayer.getCivilizationType()).getCivilizationBuildings(iOldClassTemple)
			iOldCathedral = gc.getCivilizationInfo(pPlayer.getCivilizationType()).getCivilizationBuildings(iOldClassCathedral)
			iOldMonastery = gc.getCivilizationInfo(pPlayer.getCivilizationType()).getCivilizationBuildings(iOldClassMonastery)
		else:
			iOldTemple = iChaosTemple
			iOldCathedral = iChaosCathedral
			iOldMonastery = iChaosMonastery 
		
		(loopCity, iter) = pPlayer.firstCity(false)
		
		while loopCity:
			
			if (iNewReligion != -1) and loopCity.isHasReligion(iNewReligion): # new != (old or chaos)
				if (iOldReligion == -1) or loopCity.isHasReligion(iOldReligion):  # old = (old or chaos) -> new != (old or chaos)
					if loopCity.getNumRealBuilding(iOldTemple) == 1:
						loopCity.setNumRealBuilding(iOldTemple, 0)
						loopCity.setNumRealBuilding(iNewTemple, 1)
					elif loopCity.getBuildingProduction(iOldTemple) > 0:
						loopCity.setBuildingProduction(iNewTemple, loopCity.getBuildingProduction(iOldTemple))
						loopCity.setBuildingProductionTime(iNewTemple, loopCity.getBuildingProductionTime(iOldTemple))
						loopCity.setBuildingProduction(iOldTemple, 0)
					if loopCity.getNumRealBuilding(iOldCathedral) == 1:
						loopCity.setNumRealBuilding(iOldCathedral, 0)
						loopCity.setNumRealBuilding(iNewCathedral, 1)
					elif loopCity.getBuildingProduction(iOldCathedral) > 0:
						loopCity.setBuildingProduction(iNewCathedral, loopCity.getBuildingProduction(iOldCathedral))
##>>> HoTK_JP Fixed
#						loopCity.setBuildingProductionTime(iNewTCathedral, loopCity.getBuildingProductionTime(iOldCathedral))
						loopCity.setBuildingProductionTime(iNewCathedral, loopCity.getBuildingProductionTime(iOldCathedral))
##<<< HoTK_JP
						loopCity.setBuildingProduction(iOldCathedral, 0)
					if loopCity.getNumRealBuilding(iOldMonastery) == 1:
						loopCity.setNumRealBuilding(iOldMonastery, 0)
						loopCity.setNumRealBuilding(iNewMonastery, 1)
					elif loopCity.getBuildingProduction(iOldMonastery) > 0:
						loopCity.setBuildingProduction(iNewMonastery, loopCity.getBuildingProduction(iOldMonastery))
						loopCity.setBuildingProductionTime(iNewMonastery, loopCity.getBuildingProductionTime(iOldMonastery))
						loopCity.setBuildingProduction(iOldMonastery, 0)
						
				else:  # chaos -> new != chaos
					if loopCity.getNumRealBuilding(iChaosTemple) == 1:
						loopCity.setNumRealBuilding(iChaosTemple, 0)
						loopCity.setNumRealBuilding(iNewTemple, 1)
					elif loopCity.getBuildingProduction(iChaosTemple) > 0:
						loopCity.setBuildingProduction(iNewTemple, loopCity.getBuildingProduction(iChaosTemple))
						loopCity.setBuildingProductionTime(iNewTemple, loopCity.getBuildingProductionTime(iChaosTemple))
						loopCity.setBuildingProduction(iChaosTemple, 0)
					if loopCity.getNumRealBuilding(iChaosCathedral) == 1:
						loopCity.setNumRealBuilding(iChaosCathedral, 0)
						loopCity.setNumRealBuilding(iNewCathedral, 1)
					elif loopCity.getBuildingProduction(iChaosCathedral) > 0:
						loopCity.setBuildingProduction(iNewCathedral, loopCity.getBuildingProduction(iChaosCathedral))
##>>> HoTK_JP Fixed
#						loopCity.setBuildingProductionTime(iNewTCathedral, loopCity.getBuildingProductionTime(iChaosCathedral))
						loopCity.setBuildingProductionTime(iNewCathedral, loopCity.getBuildingProductionTime(iChaosCathedral))
##<<< HoTK_JP
						loopCity.setBuildingProduction(iChaosCathedral, 0)
					if loopCity.getNumRealBuilding(iChaosMonastery) == 1:
						loopCity.setNumRealBuilding(iChaosMonastery, 0)
						loopCity.setNumRealBuilding(iNewMonastery, 1)
					elif loopCity.getBuildingProduction(iChaosMonastery) > 0:
						loopCity.setBuildingProduction(iNewMonastery, loopCity.getBuildingProduction(iChaosMonastery))
						loopCity.setBuildingProductionTime(iNewMonastery, loopCity.getBuildingProductionTime(iChaosMonastery))
						loopCity.setBuildingProduction(iChaosMonastery, 0)

			elif ((iNewReligion != -1) and (not loopCity.isHasReligion(iNewReligion))) or (iNewReligion == -1):  # new = chaos
				if (iOldReligion != -1) and loopCity.isHasReligion(iOldReligion):  # old != chaos -> chaos
					if loopCity.getNumRealBuilding(iOldTemple) == 1:
						loopCity.setNumRealBuilding(iOldTemple, 0)
						loopCity.setNumRealBuilding(iChaosTemple, 1)
					elif loopCity.getBuildingProduction(iOldTemple) > 0:
						loopCity.setBuildingProduction(iChaosTemple, loopCity.getBuildingProduction(iOldTemple))
						loopCity.setBuildingProductionTime(iChaosTemple, loopCity.getBuildingProductionTime(iOldTemple))
						loopCity.setBuildingProduction(iOldTemple, 0)
					if loopCity.getNumRealBuilding(iOldCathedral) == 1:
						loopCity.setNumRealBuilding(iOldCathedral, 0)
						loopCity.setNumRealBuilding(iChaosCathedral, 1)
					elif loopCity.getBuildingProduction(iOldCathedral) > 0:
						loopCity.setBuildingProduction(iChaosCathedral, loopCity.getBuildingProduction(iOldCathedral))
						loopCity.setBuildingProductionTime(iChaosCathedral, loopCity.getBuildingProductionTime(iOldCathedral))
						loopCity.setBuildingProduction(iOldCathedral, 0)
					if loopCity.getNumRealBuilding(iOldMonastery) == 1:
						loopCity.setNumRealBuilding(iOldMonastery, 0)
						loopCity.setNumRealBuilding(iChaosMonastery, 1)
					elif loopCity.getBuildingProduction(iOldMonastery) > 0:
						loopCity.setBuildingProduction(iChaosMonastery, loopCity.getBuildingProduction(iOldMonastery))
						loopCity.setBuildingProductionTime(iChaosMonastery, loopCity.getBuildingProductionTime(iOldMonastery))
						loopCity.setBuildingProduction(iOldMonastery, 0)

			(loopCity, iter) = pPlayer.nextCity(iter, false)
	#### Religion Buildings, end

	#### Civilization Trait, start, by poyuzhe 11.25.08
	## YUAN SHU, TRAIT_EMPEROR, added by poyuzhe 12.21.08
	def onBeginGameTurn(self, argsList):
		'Called at the beginning of the end of each turn'
		iGameTurn = argsList[0]
		
		if iGameTurn == 0:
			#### Emperor, force placing Bai Bo Zei if game failed to do so, added by poyuzhe 12.31.08
			if gc.getGame().getUnitClassCreatedCount(gc.getInfoTypeForString("UNITCLASS_BAI_BO_ZEI")) == 0:
				for i in range(gc.getMap().numPlots()):
					pLoopPlot = gc.getMap().plotByIndex(i)

					if pLoopPlot.getImprovementType() != -1 and gc.getImprovementInfo(pLoopPlot.getImprovementType()).isEmperor():
						for iPlayer in range(gc.getMAX_CIV_PLAYERS()):
							if gc.getPlayer(iPlayer).isAlive():
##>>> HoTK_JP Fixed
#								CyEngine().addSign(pLoopPlot, iPlayer, CvUtil.convertToStr(gc.getImprovementInfo(pLoopPlot.getImprovementType()).getDescription()))
								CyEngine().addSign(pLoopPlot, iPlayer, gc.getImprovementInfo(pLoopPlot.getImprovementType()).getDescription())
##<<< HoTK_JP

						barbPlayer = gc.getPlayer(gc.getBARBARIAN_PLAYER())
						barbPlayer.initUnit(gc.getInfoTypeForString("UNIT_BAI_BO_ZEI"), pLoopPlot.getX(), pLoopPlot.getY(), UnitAITypes.UNITAI_CITY_DEFENSE, DirectionTypes.DIRECTION_SOUTH)
						break
		
		if iGameTurn % 1 == 0:
			pFile = open("timer.txt", "a")
			pFile.write("---------------Current Game Turn is %d.------------------\n" % iGameTurn)
			if iGameTurn == 0:
				self.beginTime = time.clock()
				self.totalTime = 0
			self.currentTime = time.clock()
			turnTime = self.currentTime - self.beginTime
			self.totalTime += turnTime
			self.beginTime = self.currentTime
			pFile.write("CurrenTurnTime = %f, TotalTime = %f\n" % (turnTime, self.totalTime))
			pFile.close()

		eGanNing = gc.getInfoTypeForString("HERO_GAN_NING")
		if gc.getGame().getHeroDebutStatus(eGanNing) == -2 and gc.getGame().getSorenRandNum(3, "Gan Ning Barbarian Sprawl") == 1:
			barbPlayer = gc.getPlayer(gc.getBARBARIAN_PLAYER())
			for i in range(gc.getMap().numPlots()):
				pLoopPlot = gc.getMap().plotByIndex(i)
				if ( pLoopPlot.area().getNumTiles() >= 10 and pLoopPlot.getTerrainType() == gc.getInfoTypeForString("TERRAIN_COAST")
				     and pLoopPlot.getY() < gc.getMap().getGridHeight() * 2 / 5 and pLoopPlot.getX() > gc.getMap().getGridWidth() / 2 and pLoopPlot.getY() > gc.getMap().getGridHeight() / 5):
##                                     and pLoopPlot.getX < gc.getMap().getGridWidth() * 4 / 5):
					pShip1 = barbPlayer.initUnit(gc.getInfoTypeForString("UNIT_MENG_CHONG"), pLoopPlot.getX(), pLoopPlot.getY(), UnitAITypes.UNITAI_PIRATE_SEA, DirectionTypes.DIRECTION_SOUTH)
					pShip2 = barbPlayer.initUnit(gc.getInfoTypeForString("UNIT_MENG_CHONG"), pLoopPlot.getX(), pLoopPlot.getY(), UnitAITypes.UNITAI_PIRATE_SEA, DirectionTypes.DIRECTION_SOUTH)
					pShip3 = barbPlayer.initUnit(gc.getInfoTypeForString("UNIT_MENG_CHONG"), pLoopPlot.getX(), pLoopPlot.getY(), UnitAITypes.UNITAI_PIRATE_SEA, DirectionTypes.DIRECTION_SOUTH)
					if pShip1 and pShip2 and pShip3:
						pShip1.setHasPromotion(gc.getInfoTypeForString("PROMOTION_SOUTHERNOR"), True)
						pShip2.setHasPromotion(gc.getInfoTypeForString("PROMOTION_SOUTHERNOR"), True)
						pShip3.setHasPromotion(gc.getInfoTypeForString("PROMOTION_SOUTHERNOR"), True)
						pHero = barbPlayer.initHero(eGanNing, pLoopPlot.getX(), pLoopPlot.getY(), True)
						gc.getGame().addHeroLegionMember(eGanNing, pShip1.getID())
						gc.getGame().addHeroLegionMember(eGanNing, pShip2.getID())
						gc.getGame().addHeroLegionMember(eGanNing, pShip3.getID())
						pHero.formLegion(False, False)
						
						for i in range(gc.getMAX_CIV_PLAYERS()):
							if gc.getPlayer(i).isHuman():
								szText = CyTranslator().getText("TXT_KEY_GAN_NING_BARBARIAN", ())             
								CyInterface().addMessage(i, False, gc.getEVENT_MESSAGE_TIME(), szText, "", InterfaceMessageTypes.MESSAGE_TYPE_MINOR_EVENT, "", gc.getInfoTypeForString("COLOR_RED"), -1, -1, False, False)

						break

		eZangBa = gc.getInfoTypeForString("HERO_ZANG_BA")
		if gc.getGame().getHeroDebutStatus(eZangBa) == -2 and gc.getGame().getSorenRandNum(10, "Zang Ba Barbarian Sprawl") == 1:
			barbPlayer = gc.getPlayer(gc.getBARBARIAN_PLAYER())
			for i in range(gc.getMap().numPlots()):
				pLoopPlot = gc.getMap().plotByIndex(i)
				if ( pLoopPlot.area().getNumTiles() >= 20
				     and pLoopPlot.isHills() and not pLoopPlot.isOwned()
				     and pLoopPlot.getY() < gc.getMap().getGridHeight() * 2 / 3 and pLoopPlot.getX() > gc.getMap().getGridWidth() * 2 / 3 and pLoopPlot.getY() > gc.getMap().getGridHeight() / 2):
					pUnit1 = barbPlayer.initUnit(gc.getInfoTypeForString("UNIT_TAI_SHAN_ZEI"), pLoopPlot.getX(), pLoopPlot.getY(), UnitAITypes.UNITAI_ATTACK, DirectionTypes.DIRECTION_SOUTH)
					pUnit2 = barbPlayer.initUnit(gc.getInfoTypeForString("UNIT_TAI_SHAN_ZEI"), pLoopPlot.getX(), pLoopPlot.getY(), UnitAITypes.UNITAI_ATTACK, DirectionTypes.DIRECTION_SOUTH)
					if pUnit1 and pUnit2:
						pUnit1.setHasPromotion(gc.getInfoTypeForString("PROMOTION_NORTHERNOR"), True)
						pUnit2.setHasPromotion(gc.getInfoTypeForString("PROMOTION_NORTHERNOR"), True)
						pHero = barbPlayer.initHero(eZangBa, pLoopPlot.getX(), pLoopPlot.getY(), True)
						gc.getGame().addHeroLegionMember(eZangBa, pUnit1.getID())
						pHero.formLegion(False, False)
					
						for i in range(gc.getMAX_CIV_PLAYERS()):
							if gc.getPlayer(i).isHuman():
								szText = CyTranslator().getText("TXT_KEY_ZANG_BA_BARBARIAN", ())             
								CyInterface().addMessage(i, False, gc.getEVENT_MESSAGE_TIME(), szText, "", InterfaceMessageTypes.MESSAGE_TYPE_MINOR_EVENT, "", gc.getInfoTypeForString("COLOR_RED"), -1, -1, False, False)

						break

		eMengHuo = gc.getInfoTypeForString("HERO_MENG_HUO")
		if gc.getGame().getHeroDebutStatus(eMengHuo) == -2 and gc.getGame().getSorenRandNum(100, "Meng Huo Barbarian Sprawl") == 1:
			barbPlayer = gc.getPlayer(gc.getBARBARIAN_PLAYER())
			for i in range(gc.getMap().numPlots()):
				pLoopPlot = gc.getMap().plotByIndex(i)
				if ( pLoopPlot.area().getNumTiles() >= 20 and pLoopPlot.getFeatureType() == gc.getInfoTypeForString("FEATURE_FALLOUT") and not pLoopPlot.isOwned()
				     and pLoopPlot.getX() < 10 and pLoopPlot.getY() < 10):
					pUnit1 = barbPlayer.initUnit(gc.getInfoTypeForString("UNIT_TENG_JIA_BING"), pLoopPlot.getX(), pLoopPlot.getY(), UnitAITypes.UNITAI_ATTACK, DirectionTypes.DIRECTION_SOUTH)
					pUnit2 = barbPlayer.initUnit(gc.getInfoTypeForString("UNIT_TENG_JIA_BING"), pLoopPlot.getX(), pLoopPlot.getY(), UnitAITypes.UNITAI_ATTACK, DirectionTypes.DIRECTION_SOUTH)
					pUnit3 = barbPlayer.initUnit(gc.getInfoTypeForString("UNIT_KHMER_BALLISTA_ELEPHANT"), pLoopPlot.getX(), pLoopPlot.getY(), UnitAITypes.UNITAI_ATTACK, DirectionTypes.DIRECTION_SOUTH)
					if pUnit1 and pUnit2 and pUnit3:
						pUnit1.setHasPromotion(gc.getInfoTypeForString("PROMOTION_SOUTHWESTERNOR"), True)
						pUnit2.setHasPromotion(gc.getInfoTypeForString("PROMOTION_SOUTHWESTERNOR"), True)
						pUnit3.setHasPromotion(gc.getInfoTypeForString("PROMOTION_SOUTHWESTERNOR"), True)
						pHero = barbPlayer.initHero(eMengHuo, pLoopPlot.getX(), pLoopPlot.getY(), True)
						gc.getGame().addHeroLegionMember(eMengHuo, pUnit1.getID())
						pHero.formLegion(False, False)
						
						for i in range(gc.getMAX_CIV_PLAYERS()):
							if gc.getPlayer(i).isHuman():
								szText = CyTranslator().getText("TXT_KEY_MENG_HUO_BARBARIAN", ())             
								CyInterface().addMessage(i, False, gc.getEVENT_MESSAGE_TIME(), szText, "", InterfaceMessageTypes.MESSAGE_TYPE_MINOR_EVENT, "", gc.getInfoTypeForString("COLOR_RED"), -1, -1, False, False)

						break
	#### Civilization Trait, end

	#### Official Belief, start, added by poyuzhe 12.01.08
	def onReligionFounded(self, argsList):
		'Religion Founded'
		iReligion, iFounder = argsList

		for i in range(gc.getMAX_CIV_PLAYERS()):
			pPlayer = gc.getPlayer(i)
			if pPlayer.isAlive() and not pPlayer.isBarbarian() and not pPlayer.isMinorCiv():
				if gc.getLeaderHeadInfo(pPlayer.getLeaderType()).getFavoriteReligion() == iReligion:
					pCity = pPlayer.getCapitalCity()
					if pCity:
						pCity.setHasReligion(iReligion, True, True, True)

	def onTechAcquired(self, argsList):
		'Tech Acquired'
		iTechType, iTeam, iPlayer, bAnnounce = argsList
		# Note that iPlayer may be NULL (-1) and not a refer to a player object

		if iPlayer != -1:
			if CyGame().isReligionFounded(gc.getInfoTypeForString("RELIGION_UNIFICATION")):
				if iTechType == gc.getInfoTypeForString("TECH_MONARCHY"):
					pPlayer = gc.getPlayer(iPlayer)
					if pPlayer.isAlive():
						pCity = pPlayer.getCapitalCity()
						if pCity:
							pCity.setHasReligion(gc.getInfoTypeForString("RELIGION_UNIFICATION"), True, True, True)
			if CyGame().isReligionFounded(gc.getInfoTypeForString("RELIGION_HERMIT")):
				if iTechType == gc.getInfoTypeForString("TECH_WEI_JIN_FENG_DU"):
					pPlayer = gc.getPlayer(iPlayer)
					if pPlayer.isAlive():
						pCity = pPlayer.getCapitalCity()
						if pCity:
							pCity.setHasReligion(gc.getInfoTypeForString("RELIGION_HERMIT"), True, True, True)
	#### Official Belief, end

	#### Emperor, start, added by poyuzhe 12.03.08
	def onImprovementBuilt(self, argsList):
		'Improvement Built'
		iImprovement, iX, iY = argsList
		pPlot = CyMap().plot(iX, iY)

		if gc.getImprovementInfo(iImprovement).isEmperor():
			for iPlayer in range(gc.getMAX_CIV_PLAYERS()):
				if gc.getPlayer(iPlayer).isAlive():
##>>> HoTK_JP Fixed
#					CyEngine().addSign(pPlot, iPlayer, CvUtil.convertToStr(gc.getImprovementInfo(iImprovement).getDescription()))
					CyEngine().addSign(pPlot, iPlayer, gc.getImprovementInfo(iImprovement).getDescription())
##<<< HoTK_JP

			barbPlayer = gc.getPlayer(gc.getBARBARIAN_PLAYER())
			barbPlayer.initUnit(gc.getInfoTypeForString("UNIT_BAI_BO_ZEI"), iX, iY, UnitAITypes.UNITAI_CITY_DEFENSE, DirectionTypes.DIRECTION_SOUTH)

	def onUnitKilled(self, argsList):
		'Unit Killed'
		unit, iAttacker = argsList
		iPlayer = unit.getOwner()
		pAttacker = gc.getPlayer(iAttacker)
		pPlayer = gc.getPlayer(iPlayer)

		if unit.getUnitType() == gc.getInfoTypeForString("UNIT_BAI_BO_ZEI"):
			pPlot = unit.plot()
			pPlot.setImprovementType(-1)
			for iPlayer in range(gc.getMAX_CIV_PLAYERS()):
				if gc.getPlayer(iPlayer).isAlive():
					CyEngine().removeSign(pPlot, iPlayer)
	#### Emperor, end

	#### OOS, start, added by poyuzhe 02.27.09
	def onGameUpdate(self, argsList):
		'sample generic event, called on each game turn slice'
		genericArgs = argsList[0][0]	# tuple of tuple of my args
		turnSlice = genericArgs[0]

		OOSLogger.doGameUpdate()
	#### OOS, end

	#### Hero, start, added by poyuzhe 06.28.09
	def onModNetMessage(self, argsList):
		'Called whenever CyMessageControl().sendModNetMessage() is called - this is all for you modders!'
		
		iData1, iData2, iData3, iData4, iData5 = argsList

		# Form Legion Stuff
		if iData1 == 0:
			pPlayer = gc.getPlayer(iData3)
			pHero = pPlayer.getUnit(iData2)
			bRegroup = False
			if iData4 == 1:
				bRegroup = True
			pHero.formLegion(bRegroup, True)
			return 0
		# Create New Hero Stuff
		elif iData1 == 1:
			unit = CyInterface().getHeadSelectedUnit()
			if unit:
				iX = unit.getX()
				iY = unit.getY()
			else:
				city = gc.getPlayer(iData2).getCapitalCity()
				if city:
					iX = city.getX()
					iY = city.getY()
				else:
					(unit, iter)= gc.getPlayer(iData2).firstUnit()
					assert (unit);
					if unit:
						iX = unit.getX()
						iY = unit.getY()
			iLeadership = -1
			iMight = -1
			iLoyalty = -1
			iCombat = -1
			iFirstPro = -1
			iSecondPro = -1
			iThirdPro = -1
			bThreePros = False
			if iData3 == 0:
				iLeadership = 90
			elif iData3 == 1:
				iMight = 90
			elif iData3 == 2:
				iLoyalty = 100
			elif iData4 == 0:
				iCombat = gc.getInfoTypeForString("UNITCOMBAT_MELEE")
			elif iData4 == 1:
				iCombat = gc.getInfoTypeForString("UNITCOMBAT_MOUNTED")
			elif iData4 == 2:
				iCombat = gc.getInfoTypeForString("UNITCOMBAT_ARCHER")
			elif iData4 == 3:
				iCombat = gc.getInfoTypeForString("UNITCOMBAT_SIEGE")
			elif iData4 == 4:
				iCombat = gc.getInfoTypeForString("UNITCOMBAT_NAVAL")
			elif iData5 == 0:
				iFirstPro = gc.getInfoTypeForString("PROMOTION_ATTACK1")
				iSecondPro = gc.getInfoTypeForString("PROMOTION_ATTACK2")
			elif iData5 == 1:
				iFirstPro = gc.getInfoTypeForString("PROMOTION_DEFENCE1")
				iSecondPro = gc.getInfoTypeForString("PROMOTION_DEFENCE2")
			elif iData5 == 2:
				iFirstPro = gc.getInfoTypeForString("PROMOTION_RESILIENT1")
				iSecondPro = gc.getInfoTypeForString("PROMOTION_RESILIENT2")
			elif iData5 == 3:
				iFirstPro = gc.getInfoTypeForString("PROMOTION_FIGHTER1")
			elif iData5 == 4:
				bThreePros = True
			gc.getGame().createRandomHero(iData2, iX, iY, iLeadership, iMight, iLoyalty, iCombat, iFirstPro, iSecondPro, iThirdPro, bThreePros)
			gc.getPlayer(iData2).recalculateGreatGeneralThreshold()
		# Recruit Hero Stuff
		elif iData1 == 2:
			bDiscount = True
			if iData4 == 0:
				bDiscount = False
			gc.getPlayer(iData3).recruitHero(iData2, bDiscount)
			if bDiscount:
				gc.getPlayer(iData3).recalculateGreatGeneralThreshold()
		# Check Core Troop / Leader Troop Stuff
		elif iData1 == 3:
			if iData4 == 0 and iData5 == 0:
				gc.getGame().addHeroCoreTroop(iData3, iData2)
			elif iData4 == 0 and iData5 == 1:
				gc.getGame().promoteAsHeroCoreTroop(iData3, iData2)
			else:
				gc.getGame().deleteHeroCoreTroop(iData3)
		# Check Member Troop / Normal Troop Stuff
		elif iData1 == 4:
			if iData4 == 0:
				gc.getGame().addHeroLegionMember(iData3, iData2)
			else:
				gc.getGame().deleteHeroLegionMember(iData3, iData2)
		# Change Current Nine Transformation Promotion
		elif iData1 == 5:
			if iData4 != -1 and iData4 != iData5:
				gc.getGame().setHeroCurrentNineTransformationPromotion(iData3, iData4)
		# Persuade Hero
		elif iData1 == 6:
			if iData2 != -1 and iData3 != -1:
				gc.getPlayer(iData3).persuadeHero(iData2)
		# Execute Hero
		elif iData1 == 7:
			if iData2 != -1 and iData3 != -1:
				gc.getPlayer(iData3).executeHero(iData2)
		# Release Hero
		elif iData1 == 8:
			if iData2 != -1 and iData3 != -1:
				gc.getPlayer(iData3).releaseHero(iData2)
		# Form Advanced Legion Stuff
		elif iData1 == 9:
			if iData2 != -1 and iData3 != -1:
				pHero = gc.getPlayer(iData2).getUnit(gc.getGame().getHeroUnitID(iData3))
				if not pHero.isNone():
					bRegroup = True
					if iData4 == 0:
						bRegroup = False
					pHero.formAdvancedLegion(bRegroup, True)
		# Join Legion / Advanced Legion Stuff
		elif iData1 == 10:
			pPlayer = gc.getPlayer(iData3)
			pHero = pPlayer.getUnit(iData4)
			pUnit = pPlayer.getUnit(iData2)
			if not pUnit.isNone():
				if iData5 == 0:
					pUnit.joinLegion( iData4 )
				else:
					pUnit.joinAdvancedLegion( iData4 )
			pPlayer.clearJoinLegionTempHeroList()
		# AI create random hero
		elif iData1 == 11:
			iLeadership = -1
			iMight = -1
			iLoyalty = -1
			iCombat = -1
			iFirstPro = -1
			iSecondPro = -1
			iThirdPro = -1
			bThreePros = False
			
			iRand = gc.getGame().getSorenRandNum(99, "hell")
			if iRand < 33:
				iRand1 = gc.getGame().getSorenRandNum(99, "bloody hell")
				if iRand1 < 33:
					iLeadership = 90
				elif iRand1 < 66:
					iMight = 90
				else:
					iLoyalty = 100
			elif iRand < 66:
				iRand1 = gc.getGame().getSorenRandNum(100, "holy hell")
				if iRand1 < 20:
					iCombat = gc.getInfoTypeForString("UNITCOMBAT_MELEE")
				elif iRand1 < 40:
					iCombat = gc.getInfoTypeForString("UNITCOMBAT_MOUNTED")
				elif iRand1 < 60:
					iCombat = gc.getInfoTypeForString("UNITCOMBAT_ARCHER")
				elif iRand1 < 80:
					iCombat = gc.getInfoTypeForString("UNITCOMBAT_SIEGE")
				else:
					iCombat = gc.getInfoTypeForString("UNITCOMBAT_NAVAL")
			else:
				iRand1 = gc.getGame().getSorenRandNum(100, "What the Hell")
				if iRand1 < 20:
					iFirstPro = gc.getInfoTypeForString("PROMOTION_ATTACK1")
					iSecondPro = gc.getInfoTypeForString("PROMOTION_ATTACK2")
				elif iRand1 < 40:
					iFirstPro = gc.getInfoTypeForString("PROMOTION_DEFENCE1")
					iSecondPro = gc.getInfoTypeForString("PROMOTION_DEFENCE2")
				elif iRand1 < 60:
					iFirstPro = gc.getInfoTypeForString("PROMOTION_RESILIENT1")
					iSecondPro = gc.getInfoTypeForString("PROMOTION_RESILIENT2")
				elif iRand1 < 80:
					iFirstPro = gc.getInfoTypeForString("PROMOTION_FIGHTER1")
				else:
					bThreePros = True
			gc.getGame().createRandomHero(iData2, iData3, iData4, iLeadership, iMight, iLoyalty, iCombat, iFirstPro, iSecondPro, iThirdPro, bThreePros)
			gc.getPlayer(iData2).recalculateGreatGeneralThreshold()
		# Clear legion member stuff
		elif iData1 == 12:
			gc.getGame().clearHeroLegionMember(iData2)
			
				
				
	def onGameStart(self, argsList):
		'Called at the start of the game'
		
		self.lNorthernCivList = [gc.getInfoTypeForString("CIVILIZATION_CAO_CAO"),
					 gc.getInfoTypeForString("CIVILIZATION_LIU_BEI"),
					 gc.getInfoTypeForString("CIVILIZATION_YUAN_SHAO"),
					 gc.getInfoTypeForString("CIVILIZATION_GONGSUN_ZAN"),
					 gc.getInfoTypeForString("CIVILIZATION_GONGSUN_DU"),
					 gc.getInfoTypeForString("CIVILIZATION_KONG_RONG"),
					 gc.getInfoTypeForString("CIVILIZATION_ZANG_BA"),
					 gc.getInfoTypeForString("CIVILIZATION_LU_BU"),
					 gc.getInfoTypeForString("CIVILIZATION_ZHANG_YANG"),
					 gc.getInfoTypeForString("CIVILIZATION_ZHANG_YAN"),
					 gc.getInfoTypeForString("CIVILIZATION_MA_TENG"),
					 gc.getInfoTypeForString("CIVILIZATION_YUAN_SHU"),
					 gc.getInfoTypeForString("CIVILIZATION_LIU_CHONG"),
					 gc.getInfoTypeForString("CIVILIZATION_ZHANG_JIAO"),
					 gc.getInfoTypeForString("CIVILIZATION_SHAN_YUE")]

		self.lSouthernCivList = [gc.getInfoTypeForString("CIVILIZATION_SUN_CE"),
					 gc.getInfoTypeForString("CIVILIZATION_LIU_BIAO"),
					 gc.getInfoTypeForString("CIVILIZATION_SHI_XIE"),
					 gc.getInfoTypeForString("CIVILIZATION_LIU_YOU"),
					 gc.getInfoTypeForString("CIVILIZATION_YAN_BAIHU"),
					 gc.getInfoTypeForString("CIVILIZATION_WANG_LANG")]

		self.SouthWesternCivList = [gc.getInfoTypeForString("CIVILIZATION_LIU_ZHANG"),
					    gc.getInfoTypeForString("CIVILIZATION_ZHANG_LU"),
					    gc.getInfoTypeForString("CIVILIZATION_MENG_HUO")]
		
		for i in range(gc.getMAX_CIV_PLAYERS()):
			pPlayer = gc.getPlayer(i)
			if pPlayer.isAlive():
				if pPlayer.hasTrait(gc.getInfoTypeForString("TRAIT_EMPEROR")):
					for j in range(gc.getMAX_CIV_PLAYERS()):
						pOtherPlayer = gc.getPlayer(j)
						if pOtherPlayer.isAlive() and pOtherPlayer.getTeam() != pPlayer.getTeam():
							pOtherPlayer.AI_changeAttitudeExtra(i, -4)
			## ZANG BA, TRAIT_DIPLOMATIC
				if pPlayer.hasTrait(gc.getInfoTypeForString("TRAIT_DIPLOMATIC")):
					for j in range(gc.getMAX_CIV_PLAYERS()):
						pOtherPlayer = gc.getPlayer(j)
						if pOtherPlayer.isAlive() and pOtherPlayer.getTeam() != pPlayer.getTeam():
							pOtherPlayer.AI_changeAttitudeExtra(i, 4)

			## City Perk Initialization
				if pPlayer.getCivilizationType() in self.lNorthernCivList:
					(loopCity, iter) = pPlayer.firstCity(False)
					while(loopCity):
						loopCity.setHasCityPerk(gc.getInfoTypeForString("CITYPERK_NORTHERN"), True)
						(loopCity, iter) = pPlayer.nextCity(iter, False)

					(loopUnit, iter) = pPlayer.firstUnit(False)
					while( loopUnit):
						if loopUnit.getUnitCombatType() != -1 and loopUnit.getUnitCombatType() != gc.getInfoTypeForString("UNITCOMBAT_HERO"):
							loopUnit.setHasPromotion(gc.getInfoTypeForString("PROMOTION_NORTHERNOR"), True)              
						(loopUnit, iter) = pPlayer.nextUnit(iter, False)
				elif pPlayer.getCivilizationType() in self.lSouthernCivList:
					(loopCity, iter) = pPlayer.firstCity(False)
					while(loopCity):
						loopCity.setHasCityPerk(gc.getInfoTypeForString("CITYPERK_SOUTHERN"), True)
						(loopCity, iter) = pPlayer.nextCity(iter, False)

					(loopUnit, iter) = pPlayer.firstUnit(False)
					while( loopUnit):
						if loopUnit.getUnitCombatType() != -1 and loopUnit.getUnitCombatType() != gc.getInfoTypeForString("UNITCOMBAT_HERO"):
							loopUnit.setHasPromotion(gc.getInfoTypeForString("PROMOTION_SOUTHERNOR"), True)
						(loopUnit, iter) = pPlayer.nextUnit(iter, False)
				elif pPlayer.getCivilizationType() in self.lSouthWesternCivList:
					(loopCity, iter) = pPlayer.firstCity(False)
					while(loopCity):
						loopCity.setHasCityPerk(gc.getInfoTypeForString("CITYPERK_SOUTHWESTERN"), True)
						(loopCity, iter) = pPlayer.nextCity(iter, False)
						
					(loopUnit, iter) = pPlayer.firstUnit(False)
					while( loopUnit):
						if loopUnit.getUnitCombatType() != -1 and loopUnit.getUnitCombatType() != gc.getInfoTypeForString("UNITCOMBAT_HERO"):
							loopUnit.setHasPromotion(gc.getInfoTypeForString("PROMOTION_SOUTHWESTERNOR"), True)
						(loopUnit, iter) = pPlayer.nextUnit(iter, False)
						
		#### Emperor, force placing Bai Bo Zei if game failed to do so, added by poyuzhe 12.31.08
		if gc.getGame().getUnitClassCreatedCount(gc.getInfoTypeForString("UNITCLASS_BAI_BO_ZEI")) == 0:
			for i in range(gc.getMap().numPlots()):
				pLoopPlot = gc.getMap().plotByIndex(i)

				if pLoopPlot.getImprovementType() != -1 and gc.getImprovementInfo(pLoopPlot.getImprovementType()).isEmperor():
					for iPlayer in range(gc.getMAX_CIV_PLAYERS()):
						if gc.getPlayer(iPlayer).isAlive():
##>>> HoTK_JP Fixed
#							CyEngine().addSign(pLoopPlot, iPlayer, CvUtil.convertToStr(gc.getImprovementInfo(pLoopPlot.getImprovementType()).getDescription()))
							CyEngine().addSign(pLoopPlot, iPlayer, gc.getImprovementInfo(pLoopPlot.getImprovementType()).getDescription())
##<<< HoTK_JP
					barbPlayer = gc.getPlayer(gc.getBARBARIAN_PLAYER())
					barbPlayer.initUnit(gc.getInfoTypeForString("UNIT_BAI_BO_ZEI"), pLoopPlot.getX(), pLoopPlot.getY(), UnitAITypes.UNITAI_CITY_DEFENSE, DirectionTypes.DIRECTION_SOUTH)
					break
	#### Hero, end
	
#################### TRIGGERED EVENTS ##################
	
#################### AUXILIARY METHODS ##################
		
	def doDebug(self,iHumanPlayer,text):
		CyInterface().addMessage(iHumanPlayer, False, 0, '#DEBUG#  ' + text, "", 0, "", CyGame().getReplayMessageColor(0), -1, -1, False, False)
    
	def doPopup(self, text):                        
		popup = PyPopup.PyPopup()
		popup.setBodyString(text)
		popup.launch()

	def getHumanPlayerIdx(self):
		for i in range(gc.getMAX_CIV_PLAYERS()):
			if gc.getPlayer(i).isHuman():
				return i
		return 0
			
	def doForceWarBetweenTwoCivs(self,szAttackCiv,szDefendCiv):
		iHumanPlayer = self.getHumanPlayerIdx()

		iAttackCiv = CvUtil.findInfoTypeNum(gc.getCivilizationInfo,gc.getNumCivilizationInfos(),szAttackCiv)
		iDefendCiv = CvUtil.findInfoTypeNum(gc.getCivilizationInfo,gc.getNumCivilizationInfos(),szDefendCiv)
		
		for i in range(gc.getMAX_CIV_PLAYERS()):
			attacker = gc.getPlayer(i)
			if (attacker.getCivilizationType() == iAttackCiv) and (attacker.isAlive()):
				for j in range(gc.getMAX_CIV_PLAYERS()):
					defender = gc.getPlayer(j)
					if (defender.getCivilizationType() == iDefendCiv) and (defender.isAlive()):                                                                                                
						attackerTeamIdx = attacker.getTeam()
						defenderTeamIdx = defender.getTeam()
						attackerTeam = gc.getTeam(attackerTeamIdx)
						defenderTeam = gc.getTeam(defenderTeamIdx)
						
						if attackerTeam.isHasMet(defenderTeamIdx) == False:
							attackerTeam.meet(defenderTeamIdx,False)
							
							
						if attackerTeam.canDeclareWar(defenderTeamIdx):
							attackerTeam.declareWar(defenderTeamIdx,False,WarPlanTypes.WARPLAN_TOTAL)
							
							if i==iHumanPlayer:
								szText = CyTranslator().getText("TXT_KEY_FORCEWAR_SENDTO_ATTACKER", (defender.getCivilizationAdjectiveKey(),))
							elif j==iHumanPlayer:
								szText = CyTranslator().getText("TXT_KEY_FORCEWAR_SENDTO_DEFENDER", (attacker.getCivilizationAdjectiveKey(),))
							else:
								szText = CyTranslator().getText("TXT_KEY_FORCEWAR_SENDTO_NEUTRAL", (attacker.getCivilizationAdjectiveKey(),defender.getCivilizationAdjectiveKey()))
								
							CyInterface().addMessage(iHumanPlayer, False, gc.getEVENT_MESSAGE_TIME(), szText, "", InterfaceMessageTypes.MESSAGE_TYPE_MINOR_EVENT, "", gc.getInfoTypeForString("COLOR_RED"), -1, -1, False, False)

							testPopup = CyPopupInfo()
							testPopup.setButtonPopupType(ButtonPopupTypes.BUTTONPOPUP_PYTHON)
							testPopup.setText(szText)
							testPopup.addPythonButton(CyTranslator().getText("TXT_KEY_KNOW_WAR_MA_TENG_HAN_SUI", ()), "")
							testPopup.addPopup(iHumanPlayer)
							

	def setForceWarPermanent(self,szAttackCiv,szDefendCiv,bPermanent):
		iHumanPlayer = self.getHumanPlayerIdx()
		
		iAttackCiv = CvUtil.findInfoTypeNum(gc.getCivilizationInfo,gc.getNumCivilizationInfos(),szAttackCiv)
		iDefendCiv = CvUtil.findInfoTypeNum(gc.getCivilizationInfo,gc.getNumCivilizationInfos(),szDefendCiv)

		for i in range(gc.getMAX_CIV_PLAYERS()):
			attacker = gc.getPlayer(i)
			if (attacker.getCivilizationType() == iAttackCiv) and (attacker.isAlive()):
				for j in range(gc.getMAX_CIV_PLAYERS()):
					defender = gc.getPlayer(j)
					if (defender.getCivilizationType() == iDefendCiv) and (defender.isAlive()):
						attackerTeamIdx = attacker.getTeam()
						defenderTeamIdx = defender.getTeam()
						attackerTeam = gc.getTeam(attackerTeamIdx)
						defenderTeam = gc.getTeam(defenderTeamIdx)

						if attackerTeam.isAtWar(defenderTeamIdx):
							bTemp = False
							
							if attackerTeam.isPermanentWarPeace(defenderTeamIdx) or bPermanent:
								attackerTeam.setPermanentWarPeace(defenderTeamIdx, bPermanent)
								bTemp = True                                                                
							if defenderTeam.isPermanentWarPeace(attackerTeamIdx) or bPermanent:
								defenderTeam.setPermanentWarPeace(attackerTeamIdx, bPermanent)
								bTemp = True

							if bTemp and not bPermanent:
								szText = CyTranslator().getText("TXT_KEY_PYTHON_WAR_IMPERMANENT", (attacker.getNameKey(), defender.getNameKey()))
								CyInterface().addMessage(iHumanPlayer, False, gc.getEVENT_MESSAGE_TIME(), szText, "", InterfaceMessageTypes.MESSAGE_TYPE_INFO, "", gc.getInfoTypeForString("COLOR_WHITE"), -1, -1, False, False)
							if bTemp and bPermanent:
								szText = CyTranslator().getText("TXT_KEY_PYTHON_WAR_PERMANENT", (attacker.getNameKey(), defender.getNameKey()))
								CyInterface().addMessage(iHumanPlayer, False, gc.getEVENT_MESSAGE_TIME(), szText, "", InterfaceMessageTypes.MESSAGE_TYPE_INFO, "", gc.getInfoTypeForString("COLOR_WHITE"), -1, -1, False, False)
								

	def changeAttitudeBetweenTwoCivs(self,szAttackCiv,szDefendCiv,iAttitude):
		iHumanPlayer = self.getHumanPlayerIdx()

		iAttackCiv = CvUtil.findInfoTypeNum(gc.getCivilizationInfo,gc.getNumCivilizationInfos(),szAttackCiv)
		iDefendCiv = CvUtil.findInfoTypeNum(gc.getCivilizationInfo,gc.getNumCivilizationInfos(),szDefendCiv)

		for i in range(gc.getMAX_CIV_PLAYERS()):
			attacker = gc.getPlayer(i)
			if (attacker.getCivilizationType() == iAttackCiv) and (attacker.isAlive()):
				for j in range(gc.getMAX_CIV_PLAYERS()):
					defender = gc.getPlayer(j)
					if (defender.getCivilizationType() == iDefendCiv) and (defender.isAlive()):
						attacker.AI_changeAttitudeExtra(j,iAttitude)
						defender.AI_changeAttitudeExtra(i,iAttitude)
						
						szText = CyTranslator().getText("TXT_KEY_PYTHON_ATTITUDE_DECREASE", (attacker.getNameKey(), defender.getNameKey(), iAttitude))
						CyInterface().addMessage(iHumanPlayer, False, gc.getEVENT_MESSAGE_TIME(), szText, "", InterfaceMessageTypes.MESSAGE_TYPE_INFO, "", gc.getInfoTypeForString("COLOR_WHITE"), -1, -1, False, False)



						
			
		
								
						
					
					
				
		
		
		

